hgr.c
hgr()
{
	char *gswitch=(char*)0xc050;
	char *hswitch=(char*)0xc054;
	char *tswitch=(char*)0xc052;
	char *mswitch=(char*)0xc057;

	gswitch[0]=0x00; /* graphics */
	hswitch[0]=0x00; /* primary page */
	tswitch[0]=0x00; /* full screen */
	mswitch[0]=0x00; /* hi_res */
}
text.c
text ()
{
	char *gswitch=(char*)0xc051;
	char *hswitch=(char*)0xc054;

	gswitch[0]=0x00; /* text */
	hswitch[0]=0x00; /* primary page */
}
plotchar.c
char __chr[760] = { 0,0,0,0,0,0,0,0,0x0c,0x0c,0x0c,0x0c,0,0x0c,0x0c,0,
		0x36,0x24,0x12,0,0,0,0,0,0x16,0x3f,0x3f,0x16,0x16,0x3f,0x16,0,
		0x0c,0x1e,0x27,0x0c,0x39,0x1e,0x0c,0,0,0x23,0x13,8,4,0x32,0x31,0,
		0x1e,0x27,0x0e,7,0x37,0x27,0x1e,0,0x0c,8,4,0,0,0,0,0,
		0x18,0x1c,0x0e,6,0x0e,0x1c,0x18,0,6,0x0e,0x1c,0x18,0x1c,0x0e,6,0,
		0x0c,0x2d,0x1e,0x3f,0x1e,0x2d,0x0c,0,0,0,0x0c,0x1e,0x1e,0x0c,0,0,
		0,0,0,0,0,0x0c,8,4,0,0,0,0x3e,0x3e,0,0,0,0,0,0,0,0,6,6,0,
		0x40,0x20,0x10,8,4,2,1,0,0x3e,0x37,0x2f,0x27,0x27,0x27,0x1f,0,
		0x1c,0x1e,0x1c,0x1c,0x1c,0x1c,0x1c,0,0x0e,0x1d,0x1c,0x0c,0x0e,7,0x3f,0,
		0x1e,0x39,0x38,0x1c,0x38,0x39,0x1e,0,0x1c,0x1e,0x1d,0x1d,0x3f,0x1c,
		0x1c,0,0x3f,0x3f,1,0x1f,0x3c,0x3d,0x1e,0,0x1e,0x27,7,0x1f,0x27,0x27,
		0x1e,0,0x3f,0x1c,0x1c,0x0e,0x0e,7,7,0,0x1e,0x27,0x27,0x1e,0x27,0x27,
		0x1e,0,0x1e,0x39,0x39,0x3e,0x38,0x39,0x1e,0,0,0,6,6,0,6,6,0,
		0,0,6,6,0,6,4,2,0x30,0x38,0x1c,0x0e,0x1c,0x38,0x30,0,
		0,0,0x3e,0x3e,0,0x3e,0x3e,0,3,7,0x0e,0x1c,0x0e,7,3,0,
		0x1e,0x39,0x38,0x38,0x1c,0,0x1c,0,0x1e,0x23,0x2b,0x37,0x1b,3,0x3e,0,
		0x1e,0x3f,0x39,0x39,0x3f,0x39,0x39,0,0x1f,0x27,0x27,0x1f,0x27,0x27,
		0x1f,0,0x1e,0x27,7,7,7,0x27,0x1e,0,0x1f,0x27,0x27,0x27,0x27,0x27,0x1e,
		0,0x3e,7,7,0x1f,7,7,0x3e,0,0x3e,7,7,0x1f,7,7,7,0,
		0x1e,0x27,7,7,0x37,0x27,0x1e,0,0x27,0x27,0x27,0x3f,0x27,0x27,0x27,0,
		0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0,0x38,0x38,0x38,0x38,0x38,0x3a,
		0x1c,0,0x27,0x27,0x27,0x1f,0x27,0x27,0x27,0,7,7,7,7,7,7,0x3f,0,
		0x16,0x3f,0x2b,0x2b,0x2b,0x2b,0x2b,0,0x1e,0x27,0x27,0x27,0x27,0x27,
		0x27,0,0x1e,0x27,0x27,0x27,0x27,0x27,0x1e,0,0x1f,0x27,0x27,0x1f,7,7,7,
		0,0x1e,0x27,0x27,0x27,0x27,0x27,0x3e,0x60,0x1f,0x27,0x27,0x1f,0x27,
		0x27,0x27,0,0x1e,0x23,0x0f,0x1e,0x3c,0x31,0x1e,0,
		0x3e,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0,0x27,0x27,0x27,0x27,0x27,0x27,
		0x1e,0,0x27,0x27,0x27,0x1e,0x1e,0x1e,0x0c,0,0x35,0x35,0x35,0x35,0x35,
		0x3f,0x1a,0,0x27,0x27,0x27,0x1e,0x27,0x27,0x27,0,
		0x27,0x27,0x27,0x3e,0x1c,0x1c,0x1c,0,0x3f,0x38,0x18,0x0c,6,7,0x3f,0,
		0x3c,0x0e,0x0e,0x0e,0x0e,0x0e,0x3c,0,1,2,4,8,0x10,0x20,0x40,0,
		0x1e,0x38,0x38,0x38,0x38,0x38,0x1e,0,0,0,4,0x0e,0x13,0,0,0,
		0,0,0,0,0,0,0,0x7f,0x0c,0x0c,4,8,0,0,0,0,0,0,0x1e,0x39,0x39,0x39,0x36,
		0,7,7,0x1f,0x27,0x27,0x27,0x1e,0,0,0,0x1e,0x27,7,0x27,0x1e,0,
		0x38,0x38,0x3e,0x39,0x39,0x39,0x1e,0,0,0,0x1e,0x27,0x1f,7,0x3e,0,
		0x1c,0x2e,0x0e,0x3e,0x0e,0x0e,0x0e,0,0,0,0x1e,0x39,0x39,0x3e,0x38,0x1f,
		7,7,7,0x1f,0x27,0x27,0x27,0,0x1c,0,0x1c,0x1c,0x1c,0x1c,0x1c,0,
		0x38,0,0x38,0x38,0x38,0x38,0x3a,0x1c,7,0x27,0x27,0x1f,0x27,0x27,0x27,0,
		0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0,0,0,0x16,0x3f,0x2b,0x2b,0x2b,0,
		0,0,0x1e,0x27,0x27,0x27,0x27,0,0,0,0x1e,0x27,0x27,0x27,0x1e,0,
		0,0,0x1f,0x27,0x27,0x27,0x1f,7,0,0,0x3e,0x39,0x39,0x39,0x3e,0x38,
		0,0,0x1c,0x2e,0x0e,0x0e,0x0e,0,0,0,0x1e,0x23,0x0c,0x31,0x1e,0,
		0x0e,0x0e,0x3e,0x0e,0x0e,0x2e,0x1c,0,0,0,0x27,0x27,0x27,0x27,0x1e,0,
		0,0,0x27,0x27,0x16,0x16,0x0c,0,0,0,0x35,0x35,0x35,0x3f,0x1a,0,
		0,0,0x27,0x27,0x1e,0x27,0x27,0,0,0,0x39,0x39,0x39,0x3e,0x38,0x1f,
		0,0,0x3f,0x1c,0x0e,7,0x3f,0,0x38,0x3c,0x0c,0x0e,0x0c,0x0c,0x3c,0x38,
		8,8,8,8,8,8,8,8,0x0e,0x1e,0x18,0x38,0x18,0x18,0x1e,0x0e,
		0,0,0,0x26,0x19,0,0,0
	    };

plotchar(num,x,y)
char num,x,y;
{
  char *gs1=(char*)0x00;      /* pointer to address on hi-res page */
  int ybase,y1,z,a,yfin,y2,j;

     for(j=0,y2=y;j<=7;++j,++y2){
			
		/* find address of char to be plotted */

		if (y2>=0 && y2<=63){
			ybase=0x2000;y1=y2;}
		else if (y2>=64 && y2<=127){
			ybase=0x2028;y1=(y2-64);}
		else if (y2>=128 && y2<=191){
			ybase=0x2050;y1=(y2-128);}

		z=y1/8;
		
		a=z*0x80+ybase;
		yfin=(y1-(z*8))*0x400 +a;
		
		gs1[yfin+x]=__chr[(num-32)*8+j];

     }
}


circle.c
int __x_aspect=1, __y_aspect=1;

circle(cx,cy,r)
int cx,cy,r;
{

    int x,y,a,b,c,d,f,m,n;
	double z=1.16;

    x=r; y=0; b=1; f=0;

    a=(-2)*x+1;
	m=__x_aspect;
	n=__y_aspect;

point:
	c=z*x;
	d=z*y;
    plot(c*m+cx,y*n+cy);
	plot(d*m+cx,x*n+cy);
    plot(-d*m+cx,x*n+cy);
    plot(-c*m+cx,y*n+cy);
    plot(-c*m+cx,-y*n+cy);
	plot(-d*m+cx,-x*n+cy);
    plot(d*m+cx,-x*n+cy);
    plot(c*m+cx,-y*n+cy);

    if(b>= -a)
        goto fin;

    y+=1; f+=b;
    b+=2;

    if(f>r)
    {
        f+=a;
        a+=2;
        x-=1;
    }
    goto point;

fin:
  ;
}
line.c
int plot(), bplot(), gplot(), rplot(), vplot();

drw(x1,y1,x2,y2)
int x1,y1,x2,y2;
{
	comline(x1,y1,x2,y2,plot);
}

bdrw(x1,y1,x2,y2)
int x1,y1,x2,y2;
{
	comline(x1,y1,x2,y2,bplot);
}

gdrw(x1,y1,x2,y2)
int x1,y1,x2,y2;
{
	comline(x1,y1,x2,y2,gplot);
}

rdrw(x1,y1,x2,y2)
int x1,y1,x2,y2;
{
	comline(x1,y1,x2,y2,rplot);
}

vdrw(x1,y1,x2,y2)
int x1,y1,x2,y2;
{
	comline(x1,y1,x2,y2,vplot);
}

int __oldx=0, __oldy=0;

lineto(x,y)
int x,y;
{
	drw(__oldx,__oldy,x,y);
}

blineto(x,y)
int x,y;
{
	bdrw(__oldx,__oldy,x,y);
}

glineto(x,y)
int x,y;
{
   	gdrw(__oldx,__oldy,x,y);
}

vlineto(x,y)
int x,y;
{
	vdrw(__oldx,__oldy,x,y);
}

rlineto(x,y)
int x,y;
{
	rdrw(__oldx,__oldy,x,y);
}

static int
comline(x1,y1,x2,y2,func)
int (*func)();
{
	register int dx,dy,ix,iy;
	int e,ei,ed,i;

	__oldx=x2; __oldy=y2;
	dx=x2-x1;
	dy=y2-y1;
	ix=1;
	if(dx<0)
		{ ix=-1;
		  dx=-dx;
		}
	iy=1;
	if(dy<0)
		{ iy=-1;
		  dy=-dy;
		}
	if(dy>dx)
		goto ylin;

	ei=2*dy;
	ed=ei-2*dx;
	e=-dx+ei;
	for(i=1;i<=dx;++i){
		(*func)(x1,y1);
		x1=x1+ix;
		if(e<0)
			e=e+ei;
		else{ 
			y1=y1+iy;e=e+ed;
		}
	}
	goto fin;

ylin:

	ei=2*dx;
	ed=ei-2*dy;
	e=-dy+ei;
	for(i=1;i<=dy;++i)
		{ (*func)(x1,y1);
		  y1=y1+iy;
		  if(e<0)
			e=e+ei;
		  else{ x1=x1+ix;e=e+ed;}
		}
fin:		  
;		   
}
plot.c
#define PAGE1 ((char *)0x2000)
static int ysum, xoff, bitoff, point, point1;

static int
whpnt()
{
	if (bitoff!=6){
		point=3<<bitoff;
		point1=0;
	} else if (xoff != 39){
		point=0x40;
		point1=1;
	} else {
		point = 0x60;
		point1=0;
	}
}

static int
pnt(evencol,bit7)
register int evencol, bit7;
{
	int base;

	if (evencol)
		base=(xoff&1?2:1);
	else
		base=(xoff&1?1:2);

	point=bit7|base<<(bitoff&6);
	point1=0;

	if (bitoff==6)
		if (evencol)
			if (xoff&1) /*point 6 in odd bytes */
				point = bit7|0x20;
			else  /* point 6 in even bytes */
				point1=bit7;
		else
			if (xoff&1) {
				if (xoff != 0x27) /* if last point on line is red, don't */
					point1=bit7;   /* turn on bit 7 of next byte */
			} else
				point = bit7|0x20;
}

static int
complot(x,y,func, evencol,bit7)
register int x,y;
int (*func)(), evencol,bit7;
{
	int y1,y2,y3;

	if(y<64)
		y1=0;
	else if (y<128)
		y1=0x28;
	else
		y1=0x50;
	y2=(y&7)<<10;
	y3=(y&0x38)<<4;
	ysum=y1+y2+y3;

	xoff=x/7;
	bitoff=x%7;

	(*func)(evencol, bit7); /*compute point & point1 */

#ifdef DEBUG
	printf("\n\ty1=%x, y2=%x, y3=%x\n",y1,y2,y3);
	printf("\txoff=%x,point=%x, point1=%x\n",xoff,point,point1);
#endif
	PAGE1[ysum+xoff] |= point;
	PAGE1[ysum+xoff+1] |= point1;
}

#define EVENCOL 1
#define ODDCOL 0

bplot(x,y)
{
	complot(x,y,pnt, EVENCOL, 0x80);
}

vplot(x,y)
{
	complot(x,y,pnt, EVENCOL, 0);
}

rplot(x,y)
{
	complot(x,y,pnt, ODDCOL, 0x80);
}

gplot(x,y)
{
	complot(x,y,pnt, ODDCOL, 0);
}

plot(x,y)
{
	complot(x,y,whpnt);
}

clear.asm
R0 equ 8
SP equ 2

clr lda #0 ;store ptr in R0
 sta R0
 lda #$20
 sta R0+1
 ldy #0
loop
 lda R0+2
 sta (R0),Y
 iny
 lda R0+3
 sta (R0),Y
 iny
 bne loop
 ldx R0+1
 inx
 stx R0+1
 txa
 cmp #$40
 bcc loop
 lda $c057 ;high res
 lda $c054 ;full screen
 lda $c052
 lda $c050 ;
 rts

	public	black_
black_	
	lda	#0
	sta	R0+2
	sta	R0+3
	jmp	clr
	public	blue_
blue_	
	lda	#$d5
	sta	R0+2
	lda	#$aa
	sta	R0+3
	jmp	clr
	public	violet_
violet_	
	lda	#$55
	sta	R0+2
	lda	#$2a
	sta	R0+3
	jmp	clr
	public	green_
green_	
	lda	#$2a
	sta	R0+2
	lda	#$55
	sta	R0+3
	jmp	clr
	public	red_
red_	
	lda	#$aa
	sta	R0+2
	lda	#$d5
	sta	R0+3
	jmp	clr
page.c
page1()
{
	*(char *)0xc054=0x00; /* primary page */
}

page2()
{
	*(char *)0xc055=0x00; /* primary page */
}

fscreen.c
fscreen()
{
	char *tswitch=(char*)0xc052;

	tswitch[0]=0x00; /* full screen */
}
mscreen.c
mscreen()
{
	char *tswitch=(char*)0xc053;

	tswitch[0]=0x00; /* mixed screen */
}
setasp.c

set_asp(x,y)
int x,y;
{
	extern __x_aspect;
	extern __y_aspect;

	__x_aspect=x;
	__y_aspect=y;
}

